# -*- coding: utf-8 -*-
try:
    import wingdbstub
except:
    pass

import sys, os, urllib2, urllib, re, requests, datetime, json
from resources.lib.content import file
#CLI_MODE = True
# from kodiswift import xbmc, xbmcgui, CLI_MODE
# from kodiswift import Plugin, storage


class DownloadQueue(object):
    def __init__(self, queue_dir):
        self.queue_dir = queue_dir
        if not os.path.isdir(queue_dir):
            os.mkdir(queue_dir)

    def job_get(self, job_id):
        try:
            job = json.loads(open(os.path.join(self.queue_dir, job_id), "r").read())
        except:
            job = None
        return job

    def job_put(self, job_id, job):
        try:
            s = json.dumps(job)
            open(os.path.join(self.queue_dir, job_id), "w").write(s)
        except:
            raise Exception("Can not store job")

    def job_remove(self, job_id):
        try:
            os.remove(os.path.join(self.queue_dir, job_id))
        except:
            pass


    def job_ids(self, filer=""):
        lst = os.listdir(self.queue_dir)
        lst.sort()
        return lst

    def jobs(self, filter=""):
        jobs = []
        for job_id in self.job_ids():
            jobs.append(self.job_get(job_id))
        return jobs

    def jobs_count(self):
        count = {}
        for job in jobs():
            stat = job["status"]
            if stat in count:
                count[stat] += 1
            else:
                count[stat] = 1
        return stat

    def clear(self):
        for job_id in self.job_ids():
            os.remove(file.join(self.queue_dir, job_id))
