# -*- coding: UTF-8 -*-
# *  GNU General Public License for more details.
# *
# *
# *  You should have received a copy of the GNU General Public License
# *  along with this program; see the file COPYING.  If not, write to
# *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
# *  http://www.gnu.org/copyleft/gpl.html
# *
# *
# *  based on https://gitorious.org/iptv-pl-dla-openpli/ urlresolver
# */
from StringIO import StringIO
import json
import re
import base64
import urllib
import sys,os

try:
    import util
except:
    pp = os.path.dirname(os.path.abspath(__file__))
    sys.path.insert(0, os.sep.join(pp.split(os.sep)[:-1]))
    import util
import requests
try:
    from requests.packages.urllib3.exceptions import InsecureRequestWarning
    requests.packages.urllib3.disable_warnings(InsecureRequestWarning)
except:
    pass

__author__ = 'ivars777'
__name__ = 'hqq' if __name__ <> "__main__" else __name__


def supports(url):
    #return False
    return _regex(url) is not None


def _decode(data):
    def O1l(string):
        ret = ""
        i = len(string) - 1
        while i >= 0:
            ret += string[i]
            i -= 1
        return ret

    def l0I(string):
        enc = ""
        dec = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/="
        i = 0
        while True:
            h1 = dec.find(string[i])
            i += 1
            h2 = dec.find(string[i])
            i += 1
            h3 = dec.find(string[i])
            i += 1
            h4 = dec.find(string[i])
            i += 1
            bits = h1 << 18 | h2 << 12 | h3 << 6 | h4
            o1 = bits >> 16 & 0xff
            o2 = bits >> 8 & 0xff
            o3 = bits & 0xff
            if h3 == 64:
                enc += unichr(o1)
            else:
                if h4 == 64:
                    enc += unichr(o1) + unichr(o2)
                else:
                    enc += unichr(o1) + unichr(o2) + unichr(o3)
            if i >= len(string):
                break
        return enc

    escape = re.search("var _escape=\'([^\']+)", l0I(O1l(data))).group(1)
    return escape.replace('%', '\\').decode('unicode-escape')


def _decode2(file_url):
    def K12K(a, typ='b'):
        codec_a = ["G", "L", "M", "N", "Z", "o", "I", "t", "V", "y", "x", "p", "R", "m", "z", "u",
                   "D", "7", "W", "v", "Q", "n", "e", "0", "b", "="]
        codec_b = ["2", "6", "i", "k", "8", "X", "J", "B", "a", "s", "d", "H", "w", "f", "T", "3",
                   "l", "c", "5", "Y", "g", "1", "4", "9", "U", "A"]
        if 'd' == typ:
            tmp = codec_a
            codec_a = codec_b
            codec_b = tmp
        idx = 0
        while idx < len(codec_a):
            a = a.replace(codec_a[idx], "___")
            a = a.replace(codec_b[idx], codec_a[idx])
            a = a.replace("___", codec_b[idx])
            idx += 1
        return a

    def _xc13(_arg1):
        _lg27 = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/="
        _local2 = ""
        _local3 = [0, 0, 0, 0]
        _local4 = [0, 0, 0]
        _local5 = 0
        while _local5 < len(_arg1):
            _local6 = 0
            while _local6 < 4 and (_local5 + _local6) < len(_arg1):
                _local3[_local6] = _lg27.find(_arg1[_local5 + _local6])
                _local6 += 1
            _local4[0] = ((_local3[0] << 2) + ((_local3[1] & 48) >> 4))
            _local4[1] = (((_local3[1] & 15) << 4) + ((_local3[2] & 60) >> 2))
            _local4[2] = (((_local3[2] & 3) << 6) + _local3[3])

            _local7 = 0
            while _local7 < len(_local4):
                if _local3[_local7 + 1] == 64:
                    break
                _local2 += chr(_local4[_local7])
                _local7 += 1
            _local5 += 4
        return _local2

    return _xc13(K12K(file_url, 'e'))


def resolve(url):
    m = _regex(url)
    if m:
        headers = {'Accept': 'text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8',
                   'Content-Type': 'text/html; charset=utf-8'}
        if "goo.gl" in url:
            data = util.request(url, headers)
            player_url = re.search("var ppage = '(.+?)'",data).group(1)
            player_url = urllib.unquote(player_url)
        else:
            vid = m.group('vid')
            player_url = "http://hqq.tv/player/embed_player.php?vid=%s&autoplay=no" % vid
            data = util.request(player_url, headers)
        b64enc = re.search('base64([^\"]+)', data, re.DOTALL)
        b64dec = b64enc and base64.decodestring(b64enc.group(1))
        enc = b64dec and re.search("\'([^']+)\'", b64dec).group(1)
        if enc:
            data = re.findall('<input name="([^"]+?)" [^>]+? value="([^"]+?)">', _decode(enc))
            post_data = {}
            for idx in range(len(data)):
                post_data[data[idx][0]] = data[idx][1]
            data = util.post(player_url, post_data, headers)
            b64enc = re.search('base64([^\"]+)', data, re.DOTALL)
            b64dec = b64enc and base64.decodestring(b64enc.group(1))
            enc = b64dec and re.search("\'([^']+)\'", b64dec).group(1)
            if enc:
                data = re.findall('<input name="([^"]+?)" [^>]+? value="([^"]*)">', _decode(enc))
                post_data = {}
                for idx in range(len(data)):
                    post_data[data[idx][0]] = data[idx][1]
                data = urllib.unquote(util.request("http://hqq.tv/sec/player/embed_player.php?" +
                                                   urllib.urlencode(post_data), headers))
                server_1 = re.search("server_1: (\w+)",data).group(1)
                link_1 = re.search("link_1: (\w+)",data).group(1)
                vid_server = re.search(r'var\s*%s\s*=\s*"([^"]*?)"'%server_1, data)
                vid_link = re.search(r'var\s*%s\s*=\s*"([^"]*?)"'%link_1, data)
                at = re.search(r'var\s*at\s*=\s*"([^"]*?)"', data)
                vid = re.search('vid: "([^"]+)"',data)
                sub_url = re.search('sub:"(.+?)"',data).group(1) if re.search('sub:"(.+?)"',data) else ""
                subs_lang = re.search('sublangs:"(.+?)"',data).group(1) if re.search('sub:"(.+?)"',data) else ""
                if sub_url:
                    subs=[{"url":sub_url,'name':subs_lang,"lang":subs_lang}]
                else:
                    subs = []
                if vid_server and vid_link and at:
                    get_data = {'server_1': vid_server.group(1),
                                'link_1': vid_link.group(1),
                                'at': at.group(1),
                                'adb': '0/',
                                'b':'1',
                                'vid': vid.group(1)}
                    # X-Requested-With: XMLHttpRequest
                    headers["X-Requested-With"] = "XMLHttpRequest"
                    html = util.request("http://hqq.tv/player/get_md5.php?"+urllib.urlencode(get_data), headers)
                    data = json.load(StringIO(html))
                    if 'file' in data:
                        file_url = _decode2(data['file'])
                        file_url = re.sub(r'\?socket=?$', '.mp4.m3u8',file_url)
                        stream  = {
                            'url': file_url,
                            'name': file_url,
                            'subs':subs,
                            'quality': 'hqq',
                            'resolver': 'hqq',
                            "headers":{"User-Agent":"Mozilla/5.0 (iPhone; CPU iPhone OS 9_2 like Mac OS X) AppleWebKit/601.1 (KHTML, like Gecko) CriOS/47.0.2526.70 Mobile/13C71 Safari/601.1.46"}
                        }
                        return [stream]
    return []


def _regex(url):
    # https://goo.gl/yMTzqf
    match = re.search("(hqq|netu)\.tv/watch_video\.php\?v=(?P<vid>[0-9A-Z]+)", url)
    if match:
        return match
    match = re.search(r'(hqq|netu)\.tv/player/embed_player\.php\?vid=(?P<vid>[0-9A-Za-z]+)', url)
    if match:
        return match
    match = re.search(r'(hqq|netu)\.tv/player/hash\.php\?hash=\d+', url)
    if match:
        match = re.search(r'var\s+vid\s*=\s*\'(?P<vid>[^\']+)\'', urllib.unquote(util.request(url)))
        if match:
            return match
    # https://goo.gl/yMTzqf
    match = re.search("(goo)\.gl/(?P<vid>[\w]+)", url)
    if match:
        return match

    b64enc = re.search(r'data:text/javascript\;charset\=utf\-8\;base64([^\"]+)', url)
    b64dec = b64enc and base64.decodestring(b64enc.group(1))
    enc = b64dec and re.search(r"\'([^']+)\'", b64dec).group(1)
    if enc:
        decoded = _decode(enc)
        match = re.search(r'<input name="vid"[^>]+? value="(?P<vid>[^"]+?)">', decoded)
        if re.search(r'<form(.+?)action="[^"]*(hqq|netu)\.tv/player/embed_player\.php"[^>]*>',
                     decoded) and match:
            return match
    return None

if __name__ == "__main__":

    url = "http://hqq.tv/player/embed_player.php?vid=nYAKgzBAf7ll"
    streams = resolve(url)
    if not streams:
        print "No streams found"
        sys.exit()
    for s in streams:
        print s
    print streams[0]["url"]
    util.play_video(streams)
    pass
