# -*- coding: UTF-8 -*-
# /*
# *      Copyright (C) 2016 Ivars777
# *
# *
# *  This Program is free software; you can redistribute it and/or modify
# *  it under the terms of the GNU General Public License as published by
# *  the Free Software Foundation; either version 2, or (at your option)
# *  any later version.
# *
# *  This Program is distributed in the hope that it will be useful,
# *  but WITHOUT ANY WARRANTY; without even the implied warranty of
# *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# *  GNU General Public License for more details.
# *
# *  You should have received a copy of the GNU General Public License
# *  along with this program; see the file COPYING.  If not, write to
# *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
# *  http://www.gnu.org/copyleft/gpl.html
# *
# */

import re,os,sys
import json
try:
    import util
except:
    pp = os.path.dirname(os.path.abspath(__file__))
    sys.path.insert(0,os.sep.join(pp.split(os.sep)[:-1]))
    import util
import requests
try:
    from requests.packages.urllib3.exceptions import InsecureRequestWarning
    requests.packages.urllib3.disable_warnings(InsecureRequestWarning)
except:
    pass

__author__ = 'ivars777'
if __name__ <> "__main__":
    __name__ = 'kodik'

headers2dict = lambda  h: dict([l.strip().split(": ") for l in h.strip().splitlines()])
headers0 = headers2dict("""
User-Agent: Mozilla/5.0 (Windows NT 10.0; WOW64; rv:50.0) Gecko/20100101 Firefox/50.0
Accept: text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8
Upgrade-Insecure-Requests: 1
DNT: 1
Connection: keep-alive
Upgrade-Insecure-Requests: 1
Cache-Control: max-age=0

""")


def supports(url):
    return True if "kodik.cc" in url else False

def resolve(url):
    global headers0
    streams = []
    try:
        r = requests.get(url,headers=headers0)
    except:
        return []
    if r.status_code<>200:
        return []
    data = r.content
    hash = re.search('hash: "(.+?)"',data).group(1)
    vid = re.search('id: "(.+?)"',data).group(1)
    quality = re.search('quality: "(.+?)"',data).group(1)
    params = "domain=&url=&type=database&hash=%s&id=%s&quality=%s"%(hash,vid,quality)
    headers = headers2dict("""
User-Agent: Mozilla/5.0 (Windows NT 10.0; WOW64; rv:50.0) Gecko/20100101 Firefox/50.0
Accept: application/json, text/javascript, */*; q=0.01
Content-Type: application/x-www-form-urlencoded; charset=UTF-8
X-Requested-With: XMLHttpRequest
Referer: %s
"""%url)
    data = requests.post("http://kodik.cc/get-video", data=params,headers=headers).content
    js = json.loads(data)
    for st in js["qualities"]:
        stream = util.item()
        stream["url"] = js["qualities"][st]["src"]
        stream["quality"]=int(st)
        stream["name"]= stream["url"]
        streams.append(stream)
    return streams

if __name__ == "__main__":

    url = "http://kodik.cc/video/10830/4269a802d1a9d9bdc53fe38488d53a52/720p"
    streams = resolve(url)
    if not streams:
        print "No streams found"
        sys.exit()
    for s in streams:
        print s
    print streams[0]["url"]
    util.play_video(streams)
    pass
