# -*- coding: UTF-8 -*-
# /*
# *      Copyright (C) 2015 Lubomir Kucera
# *
# *
# *  This Program is free software; you can redistribute it and/or modify
# *  it under the terms of the GNU General Public License as published by
# *  the Free Software Foundation; either version 2, or (at your option)
# *  any later version.
# *
# *  This Program is distributed in the hope that it will be useful,
# *  but WITHOUT ANY WARRANTY; without even the implied warranty of
# *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# *  GNU General Public License for more details.
# *
# *  You should have received a copy of the GNU General Public License
# *  along with this program; see the file COPYING.  If not, write to
# *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
# *  http://www.gnu.org/copyleft/gpl.html
# *
# */

import re,os,sys
import json
try:
    import util
except:
    pp = os.path.dirname(os.path.abspath(__file__))
    sys.path.insert(0,os.sep.join(pp.split(os.sep)[:-1]))
    import util
import urllib2
import requests
try:
    from requests.packages.urllib3.exceptions import InsecureRequestWarning
    requests.packages.urllib3.disable_warnings(InsecureRequestWarning)
except:
    pass
#from aadecode import AADecoder

__author__ = 'Jose Riha/Lubomir Kucera'
__name__ = 'openload3'


def supports(url):
    return re.search(r'openload\.\w+/embed/.+', url) is not None


#INFO_URL = API_BASE_URL + '/streaming/info'

def resolve(url):
    HTTP_HEADER = {
        'User-Agent': 'Mozilla/5.0 (Windows NT 6.1; WOW64; rv:39.0) Gecko/20100101 Firefox/39.0',
        'Accept': 'text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8',
        'Accept-Charset': 'ISO-8859-1,utf-8;q=0.7,*;q=0.3',
        'Accept-Encoding': 'none',
        'Accept-Language': 'en-US,en;q=0.8',
        'Referer': url}  # 'Connection': 'keep-alive'

    stream = util.item()
    m = re.search('https*://openload\.\w+/embed/([^/]+)', url)
    if not m:
        return stream
    vid=m.group(1)
    url2 = "https://api.openload.co/1/streaming/get?file="+vid
    r = requests.get(url2,headers=HTTP_HEADER)
    try:
        js = json.loads(r.content)
    except:
        return stream
    if js["status"] <>200:
        raise Exception(js["msg"])
    res = js["result"]
    stream["url"] = res["url"]
    stream["name"]= res["url"]
    ### Retrieve subtitles ####
    html = requests.get(url, headers=HTTP_HEADER).content
    m = re.search('<track kind="captions" src="([^"]+)" srclang="([^"]+)" label="([^"]+)"', html)
    if m:
        stream["subs"] = m.group(1)
        stream["lang"] = m.group(2)

    return [stream]


if __name__ == "__main__":

    from subprocess import call
    #url = "http://hqq.tv/player/embed_player.php?vid=235238210241210222228241233208212245&autoplay=no"
    #url = "http://hqq.tv/player/embed_player.php?vid=243221241234244238208213206212211231&autoplay=no"
    url = "http://hqq.tv/player/embed_player.php?vid=208231211231207221227243206206221244&autoplay=no"
    #url = "https://openload.co/embed/TMthIdpy4PI/"
    #url = "https://www.youtube.com/watch?v=Tx1K51_F99o"
    #url = "https://www.youtube.com/watch?v=8BkcX7O1890"
    #url = "https://www.youtube.com/watch?v=Se07R8SYsg0"
    #url = "https://kinostok.tv/embed/731f3437e3c53104dd56d04039a0b15a"
    #url = "http://vk.com/video_ext.php?oid=246066565&id=169244575&hash=d430ab0e76c9f7a1&hd=3"
    #url ="https://openload.co/embed/rPMXJYPTkw4/"
    #url = "https://openload.co/embed/bE7WfZ-vz_A/"
    #url = "https://openload.co/embed/bE7WfZ/"
    #url = "https://openload.co/embed/OuskaKyC2GU/"
    url = "http://hqq.tv/player/embed_player.php?vid=235238210241210222228241233208212245&autoplay=no"
    url = "https://openload.co/embed/rmNcP-0QopE/"
    url = "https://openload.co/embed/oQLXcU1ITAY/"
    streams = resolve(url)
    if not streams:
        print "No streams found"
        sys.exit()

    for s in streams:
        print s

    print streams[0]["url"]
    call([r"c:\Program Files\VideoLAN\VLC\vlc.exe",streams[0]["url"]])
    pass
