#!/usr/bin/env python
# coding=utf8
#
# This file is part of PlayStream - enigma2 plugin to play video streams from various sources
# Copyright (c) 2016 ivars777 (ivars777@gmail.com)
# Distributed under the GNU GPL v3. For full terms see http://www.gnu.org/licenses/gpl-3.0.en.html
#
try:
    import json
except:
    import simplejson as json

import urllib2, urllib
import datetime, time,re, sys,os
from collections import OrderedDict
from SourceBase import SourceBase
import util
import ssl
if "_create_unverified_context" in dir(ssl):
    ssl._create_default_https_context = ssl._create_unverified_context


headers2dict = lambda  h: dict([l.strip().split(": ") for l in h.strip().splitlines()])
import HTMLParser
h = HTMLParser.HTMLParser()

class Source(SourceBase):

    def __init__(self,language="en",cfg_path=None):
        self.name = "euronews"
        self.title = "Euronews"
        self.img = "euronews.png"
        self.desc = "Euronews live and archive"
        self.headers = headers2dict("""
User-Agent: Euronews/4.0.126
Content-Type: application/json
Connection: keep-alive
        """)
        #self.language=language
        cur_directory = os.path.dirname(os.path.abspath(__file__))
        if not cfg_path: cfg_path = cur_directory
        self.config_file = os.path.join(cfg_path,self.name+".cfg")
        self.options = OrderedDict([("language","en")])
        self.options_read()
        self.vid={"1": "News", "2": "European Affairs", "3": "Lifestyle", "4": "Knowledge"}
        self.languages = []
        try:
            self.get_languages()
        except:
            pass

    def login(self,user="",password=""):
        return True

    def get_content(self, data):
        print "[%s] get_content:"%self.name, data
        source,data,path,plist,clist,params,qs = self.parse_data(data)
        #lang = qs["lang"] if "lang" in qs else self.language
        lang = self.options["language"]
        if not lang in self.get_languages():
            raise Exception("Not valid default language - '%s'"%lang)

        content=[]
        content.append(("..return", "back","back.png","Return back"))

        if clist=="home":
            content.extend([
                ("Search", "euronews::content/getSearch?lang=%s&byPage=40&page=1&text={0}"%lang,self.img,"Top stories timeline"),
                ("Live stream", "euronews::live?lang=%s"%lang,self.img,"Euronews live stream"),
                ("Just in", "euronews::content/getTimeline?lang=%s&byPage=40&page=1"%lang,self.img,"News timeline"),
                ("Top stories", "euronews::content/getTopStories?lang=%s"%lang,self.img,"Top stories timeline"),
                ("Category - News", "euronews::content/getVertical?lang=%s&byPage=40&page=1&vId=1"%lang,self.img,"Category - News"),
                ("Category - European Affairs", "euronews::content/getVertical?lang=%s&byPage=40&page=1&vId=2"%lang,self.img,"Category - European Affairs"),
                ("Category - Lifestyle", "euronews::content/getVertical?lang=%s&byPage=40&page=1&vId=3"%lang,self.img,"Category - Lifestyle"),
                ("Category - Knowledge", "euronews::content/getVertical?lang=%s&byPage=40&page=1&vId=4"%lang,self.img,"Category - Knowledge"),
                ("Latest programs", "euronews::content/getLatestPrograms?lang=%s&byPage=40&page=1"%lang,self.img,"Latest programs"),
                ("Programs list", "euronews::content/getPrograms?lang=%s"%lang,self.img,"Programs list"),
             ])
            return content


        ### Video arhīvs ###
        elif clist=="content":
            if "lang" in qs:
                del qs["lang"]
            params = json.dumps(qs)

            req = '{"methodName":"content.%s","apiKey":"androidPhoneEuronews-1.0","params":%s,"language":"%s"}'%(plist[1],params,lang)
            r = self.call(req)
            if not r:
                return content
            lst = r["timeline"] if "timeline" in r else\
                r["topstorieslist"] if "topstorieslist" in r else\
                r["programs"] if "programs" in r else\
                r["programDetailsList"] if "programDetailsList" in r else\
                r["programlist"] if "programlist" in r else\
                r["articlelist"] if "articlelist" in r else\
                r["verticals"] if "verticals" in r else\
                []
            if not lst:
                return content

            for item in lst:
                if plist[1] in ("getTimeline"):
                    article = item["article"]
                    atype = item["type"]
                    if item["type"] == "wire":
                        continue # TODO
                else:
                    article = item
                    atype = "article"
                if plist[1]=="getPrograms":
                    title = article["title"]
                    id = article["pId"]
                    desc = title
                    img = "http://static.euronews.com/articles/programs/533x360_%s"%article["img"]
                    data2 = "content/getProgramDetails?lang=%s&byPage=40&page=1&pId=%s"%(lang,id)
                    content.append((title,self.name+"::"+data2,img,desc))
                else:
                    title = article["title"] if "title" in article else article["text"] if "text" in article else "No title"
                    if atype <> "article":
                        title = "[%s] %s"%(atype,title)
                    atime = datetime.datetime.fromtimestamp(int(article["uts"]))
                    #atime = datetime.datetime.fromtimestamp(int(article["uts"])-time.altzone)
                    atime = atime.strftime("%Y-%m-%d %H:%M")
                    vert = self.vid[article["vId"]] if "vId" in article else ""
                    ptitle = article["pTitle"] if "pTitle" in article else ""
                    id = article["id"]
                    desc = "%s\n%s\n%s %s"%(title,atime,vert,ptitle)
                    img = "http://static.euronews.com/articles/%s/399x225_%s.jpg"%(id,id)
                    if not atype in ("breakingnews","wire"):
                        data2 = "content/getArticle?lang=%s&id=%s"%(lang,id)
                    else:
                        data2 = ""
                    content.append((title,self.name+"::"+data2,img,desc))
            if "page=" in data:
                data2 = re.sub("page=\d+","page=%s"%(int(qs["page"])+1),data)
                content.append(("Next page",self.name+"::"+data2,"next.png","Next page"))
            return content


    def is_video(self,data):
        source,data,path,plist,clist,params,qs = self.parse_data(data)
        if path == "live":
            return True
        elif clist=="content" and plist[1]=="getArticle":
            return True
        else:
            return False

    def get_streams(self, data):
        print "[euronews] get_streams:", data
        if not self.is_video(data):
            return []
        source,data,path,plist,clist,params,qs = self.parse_data(data)
        #lang = qs["lang"] if "lang" in qs else self.language
        lang = self.options["language"]
        if not lang in self.get_languages():
            raise Exception("Not valid default language - '%s'"%lang)

        streams = []

        if path == "live":
            if "lang" in qs:
                del qs["lang"]
            languages = self.get_languages()
            for lang in languages:
                # http://api.euronews.com/ipad/androidPhoneEuronews-1.4/live.getUrl/en
                data2 =  "live.getUrl/%s" % lang
                js = self.call2(data2)
                if not "primary" in js:
                    continue
                stream = util.item()
                stream["url"]=js["primary"]
                stream["lang"]= lang
                stream["quality"]="variant"
                stream["name"]="Euronews live [%s]"%lang
                stream["desc"]=stream["name"]
                stream["type"]="hls" #stream_type(url)
                streams.append(stream)
            if not streams:
                raise Exception("No streams found!")

        elif clist=="content" and plist[1] == "getArticle":
            if "lang" in qs:
                del qs["lang"]
            languages = self.get_languages()
            for lang in languages:
                id = qs["id"]
                url = "content.getArticle/%s?format=html&id=%s" % (lang, id)
                r = self.call2(url)
                if not r:
                    raise Exception("No live stream found")
                if not "articlelist" in r:
                    msg = r["label"] if "label" in r else "No article find"
                    continue
                    #raise Exception(msg)
                article = r["articlelist"]
                stream = util.item()
                stream["url"]=article["videoUri"] if "videoUri" in article else ""
                if not stream["url"]:
                    return []
                stream["lang"]=lang
                stream["quality"]="?"
                stream["name"]= article["title"]
                stream["desc"]=article["text"] if "text" in article else article["title"]
                stream["type"]="http" #stream_type(url)
                streams.append(stream)

        else:
            raise Exception("No live stream found")

        ### TODO - sakārtot sarakstu, lai pirmais ir labakais video
        qlist = ["???","lq","mq","hq","hd","variant"]
        llist = ["fr","en","ru","lv"]
        for s in streams:
            if s["lang"]==self.options["language"]:
                s["order"] = 10000
                continue
            lv = llist.index(s["lang"])*10 if s["lang"] in llist else 0
            qv=qlist.index(s["quality"]) if s["quality"] in qlist else 0
            s["order"] = lv+qv
        streams = sorted(streams,key=lambda item: item["order"],reverse=True)
        return streams

    def get_languages(self):
        if self.languages: return self.languages
        url = "http://www.euronews.com/"
        r = self._http_request(url)
        result = re.findall(r'<option value="([^"]+)"\s*(selected)*\slang="([^"]+)" hreflang="([^"]+)">', r, re.DOTALL)
        languages = []
        for item in result:
            languages.append(item[3])
        if not languages:
            raise Exception("Can not get languages list")
        self.languages = languages
        return self.languages


    def get_languages0(self):
        if self.languages: return self.languages
        url = "http://www.euronews.com/api/watchlive.json"
        r = self._http_request(url)
        try:
            js = json.loads(r)
            url = js["url"]
        except:
            raise Exception("Can not get languages list")
        r = self._http_request(url)
        try:
            js = json.loads(r)
            if not js["status"]=="ok":
                raise Exception("Can not get languages list")
        except:
            raise Exception("Can not get languages list")

        slist = js["primary"]
        self.languages=slist.keys()
        return self.languages

    def call(self, data,params = None, headers=None):
        if not headers: headers = self.headers
        #if not lang: lang = self.country
        url = "http://api.euronews.com/ipad/"
        headers = headers2dict("""
User-Agent: Euronews/4.0.126
Content-Type: multipart/form-data, boundary=AaB03xBounDaRy; charset=UTF-8
Host: api.euronews.com
Connection: Keep-Alive
        """)
        params = """
--AaB03xBounDaRy
content-disposition: form-data; name=request

%s
--AaB03xBounDaRy--
"""%data
        content = self._http_request(url, params, headers)
        if content:
            try:
                result = json.loads(content)
                return result
            except Exception, ex:
                return None
        else:
            return None

    def call2(self, data, headers=None):
        if not headers: headers = self.headers
        #if not lang: lang = self.country
        url = "http://api.euronews.com/ipad/androidPhoneEuronews-1.4/" + data
        headers = headers2dict("""
User-Agent: okhttp/3.8.1
   """)
        content = self._http_request(url, headers=headers)
        if content:
            try:
                result = json.loads(content)
                return result
            except Exception, ex:
                return None
        else:
            return None


if __name__ == "__main__":
    language= "en"
    c = Source(language)
    sys.path.insert(0, os.path.dirname(os.path.dirname(__file__)))
    import run
    source = Source(language)
    data= sys.argv[1] if len(sys.argv)>1 else source.name+"::home"
    run.run(source, data)
    sys.exit()

    #c = Source(language)
    #data = '{"methodName":"content.getTimeline","apiKey":"androidPhoneEuronews-1.0","params":{"page":"1","byPage":"30"},"language":"en"}'
    #r = c.call(data)
