#!/usr/bin/env python
# coding=utf8
#
# This file is part of PlayStream - enigma2 plugin to play video streams from various sources
# Copyright (c) 2016 ivars777 (ivars777@gmail.com)
# Distributed under the GNU GPL v3. For full terms see http://www.gnu.org/licenses/gpl-3.0.en.html
#
try:
    import json
except:
    import simplejson as json
import urllib2, urllib
import binascii
import datetime, re, sys,os, time
import ConfigParser
from collections import OrderedDict
from SourceBase import SourceBase
import requests
import ssl
if "_create_unverified_context" in dir(ssl):
    ssl._create_default_https_context = ssl._create_unverified_context

try:
    from requests.packages.urllib3.exceptions import InsecureRequestWarning
    requests.packages.urllib3.disable_warnings(InsecureRequestWarning)
except:
    pass
#import resolver
try:
    import util
except:
    sys.path.insert(0,'..')
    import util

headers2dict = lambda  h: dict([l.strip().split(": ") for l in h.strip().splitlines()])

class Source(SourceBase):

    def __init__(self, country="",cfg_path=None):
        self.hidden = False # nerāda menu nestrādājošos avotus
        self.name = "filmas"
        self.title = "Filmas.lv"
        self.img = "filmas.png"
        self.desc = "Filmas.lv - Latvijas filmas"
        self.headers = headers2dict("""
User-Agent: Mozilla/5.0 (Windows NT 10.0; WOW64; rv:51.0) Gecko/20100101 Firefox/51.0
Accept: text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8
Accept-Language: en-US,en;q=0.5
Accept-Encoding: gzip, deflate, br
""")
        self.headers2 = headers2dict("""
User-Agent: Mozilla/5.0 (Windows NT 10.0; WOW64; rv:46.0) Gecko/20100101 Firefox/46.0
X-Requested-With: XMLHttpRequest
Accept: text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8
""")
        self.url = "https://www.filmas.lv/"


    ######### Entry point ########
    def get_content(self, data):
        print "[filmas] get_content:", data
        source, data, path, plist, clist, params, qs = self.parse_data(data)
        content = []
        content.append(("..return", "back","back.png","Return back"))

        if clist=="home":
            content.extend([
                ("Meklēt", "filmas::filmu-katalogs/?mn={0}&tab=movies&sub_tab=movies-search","","Meklēt"),
                ("Visas", "filmas::filmu-katalogs/?tab=movies&sub_tab=movies-view-1","","Visur skatam visas filmas"),
                ("Spēlfilmas", "filmas::filmu-katalogs/?tab=movies&sub_tab=movies-view-1&mp20=112","","Visur skatamās spēlfilmas"),
                ("Animācijas filmas", "filmas::filmu-katalogs/?tab=movies&sub_tab=movies-view-1&mp20=113","","Visur skatamās animācijas filmas"),
                ("Dokumentalās filmas", "filmas::filmu-katalogs/?tab=movies&sub_tab=movies-view-1&mp20=111","","Visur skatamās dokumentalās filmas"),
                ("Kinohronikas", "filmas::filmu-katalogs/?tab=movies&sub_tab=movies-view-1&mp20=150","","Visur skatamās kinohronikas")    ,
            ])
            return content

        elif clist=="filmu-katalogs":
            r=self.call(data)
            result = re.findall(r'<a href="/(movie/\d+)">.+?<img src="/([^"]+)">.+?Pieejama.+?<div class="katalogs-filma-teksts">\s*(.+?)\s*<span style="font-weight:normal; ">\((\d+)\)</span>', r, re.DOTALL)
            for item in result:
                title = item[2]+'(%s)'%item[3]
                data2 = item[0]
                img = self.url + item[1].replace("thumbs_m/","")
                desc = title
                content.append((title,self.name+"::"+data2,img,desc))
            m = re.search(r"<a class='pagenum' href='(\?tab=movies&sub_tab=movies-view-2[^']+)'>&gt;</a>", r, re.DOTALL)
            if m:
                data2 = "filmu-katalogs/"+m.group(1)
                content.append(("Next page",self.name+"::"+data2, "","Next page"))
            return content

        ### kaut kas neparedzets ###
        else:
            return content

    def is_video(self,data):
        source,data,path,plist,clist,params,qs = self.parse_data(data)
        if clist=="movie":
            return True
        else:
            return False

    def call(self, data,params=None,headers=None,lang=""):
        if not headers: headers = self.headers
        url = self.url+data
        result = self._http_request(url,params,headers=headers)
        return result

    def get_streams(self,data):
        print "[filmas] get_streams:", data
        source, data, path, plist, clist, params, qs = self.parse_data(data)
        streams = []
        url = self.url+data
        mid = data.split("/")[1]
        r = requests.get(url, headers=self.headers, verify=False)
        if not "PHPSESSID" in r.cookies:
            return streams
        phpsessid = r.cookies["PHPSESSID"]

        ### Main playlist ###
        hid = re.search('src: "/lmdb/hls/playlist/(\w+).m3u8"', r.content).group(1)
        url = "https://www.filmas.lv/lmdb/hls/playlist/%s.m3u8"%hid
        headers = headers2dict("""
User-Agent: Mozilla/5.0 (Windows NT 10.0; WOW64; rv:51.0) Gecko/20100101 Firefox/51.0
Accept: */*
Accept-Language: en-US,en;q=0.5
Accept-Encoding: gzip, deflate, br
Referer: https://www.filmas.lv/movie/%s/
            """%mid)
        r = requests.get(url, headers=headers, verify=False, cookies={"phpsessid":phpsessid} )
        filmassession = r.cookies["filmassession"]
        result = re.findall(r'#EXT-X-STREAM-INF:PROGRAM-ID=(\d+),BANDWIDTH=(\d+),RESOLUTION=(.+?),CODECS="(.+?)"\n(.+?)$', r.content, re.IGNORECASE | re.MULTILINE)
        title = url.split("/")[-1].split(".")[0]

        ### Initial key requests
        url = "https://www.filmas.lv/lmdb/hls/key/request/%s?%s"%(mid,int(time.time()))
        r=requests.get(url,headers=headers,cookies = {"filmassession":filmassession}, verify=False )
        filmassession = r.cookies["filmassession"]

        ### Metada ###
        url = "https://www.filmas.lv/charts/api/api/?method=search_movie&query=%s"%mid
        r = requests.get(url, headers=headers, verify=False)
        if not "error" in r.content:
            title = r.json()["nodes"][0]["name"]
            img = self.url+r.json()["nodes"][0]["image"]
            desc = r.json()["nodes"][0]["plot"]
        else:
            img = desc = ""

        for h in result:
            url = h[4]

            ### Key request ###
            headers["Origin"] = "https://www.filmas.lv"
            headers["Cookie"] = 'filmassession=%s; PHPSESSID=%s' % (filmassession, phpsessid)
            #r=requests.get(url,headers=headers, verify=False)
            #url_key = re.search('#EXT-X-KEY:METHOD=AES-128,URI="(.+?)"', r.content, re.IGNORECASE | re.MULTILINE).group(1)
            #r=requests.get(url_key,headers=headers, cookies={"filmassession":filmassession,"PHPSESSID":phpsessid}, verify=False)
            #key = r.content if not "error" in r.content else ""

            stream = util.item()
            stream["name"] = title
            stream["url"] = url
            stream["img"] = img
            stream["desc"] = desc
            stream["headers"] = headers #{"key":binascii.b2a_hex(key)}
            stream["quality"] = h[2]
            stream["order"] = int(h[1])
            stream["resolver"] = "filmas"
            streams.append(stream)

        return  sorted(streams,key=lambda item: item["order"],reverse=True)


def download_hls(url, title, download_dir="", headers=None, overwrite=True):
    UA = "Mozilla/5.0 (Windows NT 10.0; WOW64; rv:51.0) Gecko/20100101 Firefox/51.0"
    if not headers:
        headers = {"User-Agent" : UA}
    key = headers["key"] if "key" in headers else ""
    if not "User-Agent" in headers:
        headers["User-Agent"] = UA
    tsname = os.path.join(download_dir,title+".ts")
    if not os.path.exists(tsname) or overwrite:
        tsfile = open(tsname,"wb")
        print "Downloading ", tsname
        try:
            r=requests.get(url,headers=headers, verify=False)
        except Exception as e:
            print "Got Exception: ", str(e)
            import traceback
            traceback.print_exc()
            sys.exit()
        ts_list = re.findall(r"#EXTINF:([\d\.]+),\n(.+?)$", r.content, re.IGNORECASE | re.MULTILINE)
        for ts in ts_list:
            url2 = ts[1]
            #print "Downloading ", url2
            #fname = os.path.join(download_dir,url2.split("/")[-1])
            r = requests.get(url2, headers=headers, verify=False)
            content = r.content
            if key:
                from Crypto.Cipher import AES
                key2 = binascii.a2b_hex(key)
                iv = content[:16]
                d = AES.new(key2, AES.MODE_CBC, iv)
                content = d.decrypt(content[16:])
            #with open(fname,"wb") as f:
                #f.write(content)
            tsfile.write(content)
            #lfile.write("file '%s'"%fname)
        #lfile.close()
        tsfile.close()
    from subprocess import call
    cmd = [r"ffmpeg.exe","-i", tsname.encode(sys.getfilesystemencoding()), "-c","copy", os.path.join(download_dir,title+".mp4").encode(sys.getfilesystemencoding())]
    ret = call(cmd)


if __name__ == "__main__":

    #url = "http://localhost:88/https%3A//as2.filmas.lv/FilmasLV/508D4024A83FDC1AA61D727DE5046D12/index-f3-v1-a1.m3u8?~key=4cb5c12b2aaa3d2cf211583cc9add2dd"
    #download_hls(url, "video", "")

#     c = Source()
#     if len(sys.argv)>1:
#         data= sys.argv[1]
#     else:
#         data = "movie/3112/"
#     if "movie" in data:
#         if data.startswith("http"):
#             data = data.replace("https://www.filmas.lv/","")
#         streams = c.get_streams(data)
#         #for s in streams:
#         s = streams[0]
#         download_hls(s["url"],"%s %s"%(s["name"],s["quality"]),"",s["headers"])
#         sys.exit()

    sys.path.insert(0, os.path.dirname(os.path.dirname(__file__)))
    import run
    source = Source()
    data= sys.argv[1] if len(sys.argv)>1 else source.name+"::home"
    run.run(source, data)
    sys.exit()
