#!/usr/bin/env python
# coding=utf8
#
# This file is part of PlayStream - enigma2 plugin to play video streams from various sources
# Copyright (c) 2016 ivars777 (ivars777@gmail.com)
# Distributed under the GNU GPL v3. For full terms see http://www.gnu.org/licenses/gpl-3.0.en.html
#
try:
    import json
except:
    import simplejson as json
import urllib2, urllib
import datetime, re, sys,os
from collections import OrderedDict
import ssl
if "_create_unverified_context" in dir(ssl):
    ssl._create_default_https_context = ssl._create_unverified_context

from SourceBase import SourceBase
import util

headers2dict = lambda  h: dict([l.strip().split(": ") for l in h.strip().splitlines()])
headers0 = headers2dict("""
User-Agent: Mozilla/5.0 (Windows NT 6.3; rv:36.0) Gecko/20100101 Firefox/36.04
Accept: application/json, text/javascript, */*; q=0.01
Accept-Language: en-US,en;q=0.5
Accept-Encoding: gzip, deflate, br
Content-Type: application/x-www-form-urlencoded; charset=UTF-8
X-Requested-With: XMLHttpRequest""")
import HTMLParser
h = HTMLParser.HTMLParser()

class Source(SourceBase):

    def __init__(self,country="lv",cfg_path=None):
        self.name = "tvdom"
        self.title = "TVDom.tv"
        self.img = "tvdom.png"
        self.desc = "TVDom.tv portāla satura skatīšanās"
        self.headers = headers0
        self.url = "https://tvdom.tv/"

        self.country=country
        self.session = None
        self.token = None

        cur_directory = os.path.dirname(os.path.abspath(__file__))
        if not cfg_path: cfg_path = cur_directory
        self.config_file = os.path.join(cfg_path,self.name+".cfg")
        self.options = OrderedDict([("user","lietotajs"),("password","parole"), ("region", "lv"), ("lang", "lv")])
        self.options_read()

    def login(self,user="",password=""):
        self.options_read()
        if not user: user=self.options["user"]
        if not password: password = self.options["password"]
        headers = headers2dict("""
User-Agent: Mozilla/5.0 (Windows NT 10.0; WOW64; rv:49.0) Gecko/20100101 Firefox/49.0
Accept: */*
Accept-Language: en-US,en;q=0.5
Accept-Encoding: gzip, deflate, br
Content-Type: application/x-www-form-urlencoded; charset=UTF-8
X-Requested-With: XMLHttpRequest
Referer: https://tvdom.tv/
        """)
        url = "https://tvdom.tv/infinity/on_register_user"
        params = "email=%s&password=%s&remember=false&auth_type=login"%(user,password)
        import requests
        try:
            from requests.packages.urllib3.exceptions import InsecureRequestWarning
            requests.packages.urllib3.disable_warnings(InsecureRequestWarning)
        except:
            pass
        r = requests.post(url, data=params, headers=headers)
        js = json.loads(r.content)
        if 'success' in r.content:
            self.token = js["access_token"]
            if 'PHPSESSID' in r.cookies:
                self.session = r.cookies["PHPSESSID"]
            return True
        else:
            raise Exception(js["error"])


    def get_content(self, data):
        print "[tvdom] get_content:", data
        source,data,path,plist,clist,params,qs = self.parse_data(data)
        lang = self.options["lang"]
        region = self.options["region"]
        content=[]
        content.append(("..return", "back","back.png","Return back"))

        if clist=="home":
            content.extend([
                ("Live stream", "tvdom::tiesraides","","TV live streams"),
                ("Archive - last", "tvdom::arhivs?filter=new&page=0&limit=30&region=%s&language=%s" % (region, lang),"","Video archive - last videos"),
                ("Archive - popular", "tvdom::arhivs?filter=new&page=0&limit=30&region=%s&language=%s"% (region, lang),"","Video archive - popular video"),
                ("Archive - categories", "tvdom::arhivs","","Video archive by categories"),
                ("Search", "tvdom::search/?srch-term={0}","","Search archive"),

                #("Archive - all", "tvdom::arhivs_all","","Video archive all"),
            ])
            return content

        ### Tiesraides kanalu saraksts ###
        elif data=="tiesraides":
            data1 = "infinity/on_front_filter_channels_list.json"
            params = "hd=&language=%s&region=%s" % (self.options["lang"], self.options["region"])
            r = self.call_json(data1, params)
            for genre in  r["data"]:
                for item in r["data"][genre]:
                    ch = item["channel_name"]
                    title = u"%s - %s" % (item["channel_name"], item["program_title"])
                    img = "https://tvdom.tv"+item["channel_logo"]
                    data2 = item["program_url"][1:]
                    desc = u"%s\n%s-%s"%(title,item["time_start"],item["time_stop"])
                    content.append((title,self.name+"::"+data2,img,desc))
            return content

#         elif clist == "tiesraides":
#             if not self.session:
#                 self.login()
#             url = "https://tvdom.tv/" + data
#             headers = self.headers
#             headers["Cookie"] = "PHPSESSID=%s; neverending_story=1;"%self.session
#             r = self._http_request(url,headers=headers)
#             m = re.search("var streamConnectionUrl = '([^']+)'", r, re.DOTALL)
#             if m:
#                 data2 = m.group(1)
#             else:
#                 return ("No stream found %s"%data,"","","No stream found")
#             m = re.search('title: "([^"]+)"', r, re.DOTALL)
#             title = m.group(1) if m else data2
#             m = re.search('<div id="panel">([^<]+)<', r, re.DOTALL)
#             desc = m.group(1) if m else title
#             m = re.search('<div id="panel">([^<]+)<', r, re.DOTALL)
#             desc = m.group(1) if m else title
#             m = re.search('var promo_image *= "([^"]+)', r, re.DOTALL)
#             img = m.group(1) if m else ""
#             return (title,data2,img,desc)

        ### Search ###
        elif clist=="search":
            url = "https://tvdom.tv/" + data
            r = self._http_request(url)
            result = re.findall(r'<div class="film-block_img">\s*<img src="([^"]+).+?<a href="/([^"]+)">([^<]+)</a>\s*</div>\s*<ul class="film-block_descr_tag">\s*<li><a href="">([^<]+)</a>', r, re.DOTALL)
            for item in result:
                title = item[2] + " ("+ item[3] + ")"
                title =  h.unescape(title.decode("utf8")).encode("utf8")
                img = "https://tvdom.tv" + item[0]
                data2 = item[1]
                desc = title
                content.append((title,self.name+"::"+data2,img,desc))
            return content

        ### Arhīva kategorijas ###
        elif data=="arhivs":
            url = "https://tvdom.tv/"+data
            headers = self.headers
            headers["Cookie"] = "neverending_story=1; user_selected_language=%s"% (self.options["lang"])
            r = self._http_request(url)
            result = re.findall(r'data-text-mobile="(.+?)" data-id="(\d+)" data-filter-type="archive_genre">', r)
            for item in result:
                title = item[0]
                img = ""
                data2 = "arhivs?" + "genre1=%s&filter=new&region=%s&lang=%s&page=0&limit=30" % (item[1], region, lang)
                desc = title
                content.append((title,self.name+"::"+data2,img,desc))
            return content

        ### Arhīva kategorijas programmas ###
        elif clist=="arhivs":
            data1 = "infinity/on_front_archive_get_events2.json"
            r = self.call_json(data1, params[1:])

            for item in r["data"]:
                title = item["title"] + "- " + item["online_time"]
                img = "https://tvdom.tv"+item["image"]
                data2 = item["url"][1:]
                desc = u"%s\nlast: %s\npopularity: %s\n%s" % (title, item["online_time"], item["popularity"], item["channel_code"])
                content.append((title,self.name+"::"+data2,img,desc))
            if len(r["data"]) == 30:
                page = int(qs["page"]) + 1
                data2 = re.sub("page=\d+", "page=%s" % page, data)
                content.append(("Next page",self.name+"::"+data2,"","Go to next page"))
            return content

        ### Arhīva programmas video saraksts ###
        elif clist=="play_arhivs" and len(data.split("/"))==3 and not re.search("_\d+",plist[2]):
            url = "https://tvdom.tv/"+data
            r = self._http_request(url)
            vid=re.search('materialIdentifier : "(\d+)', r, re.DOTALL).group(1)
            pname = re.split("[_\.\-]", plist[-1])[0]
            data2 = data+"_"+vid
            m = re.search(r'var program_title\s*= "(.+?)"', r)
            title = title0 = m.group(1) if m else data2
            m = re.search('<p class="content-info__descr-item">(.+?)</p>', r, re.DOTALL)
            datums = m.group(1).strip() if m else ""
            title = title + " " + datums
            m = re.search('<p class="video-player__descr-text" style="height: 100px;">(.+?)<span', r, re.DOTALL)
            desc = m.group(1).strip() if m else title
            m = re.search('var share_image\s*= "([^"]+)', r, re.DOTALL)
            img = m.group(1) if m else ""
            content.append((title,self.name+"::"+data2,img,desc))
            i2 = r.find("content  content--indent-pb")
            r2 = r if i2 == -1 else r[:i2]
            result = re.findall(r'<img src="([^"]+)" class="content-item__image" alt=""><a href="/([^"]+)" class="content-item__hide-info">.+?<h3 class="content-item__name">\s*<a href="#">\s*([^<]*)\s*<br>\s*([^<]*)\s*</a>\s*</h3>', r2, re.DOTALL)
            for item in result:
                if pname not in item[1]:
                    continue
                title = item[2] + " " + item[3].strip()
                title =  h.unescape(title.decode("utf8")).encode("utf8")
                img = "https://tvdom.tv"+item[0]
                data2 = item[1]
                desc = title # TODO
                content.append((title,self.name+"::"+data2,img,desc))
            return content

        ### Arhīva video
#         elif clist=="play_arhivs" and len(data.split("/"))==3 and re.search("_\d+",plist[2]):
#             url = "https://tvdom.tv/" + data
#             headers = self.headers
#             headers["Cookie"] = "PHPSESSID=%s; neverending_story=1;"%self.session
#             r = self._http_request(url,headers=headers)
#             m = re.search('var streamConnectionUrl  = "([^"]+)"', r, re.DOTALL)
#             if m:
#                 data2 = m.group(1)
#             else:
#                 return ("No stream found %s"%data,"","","No stream found")
#             m = re.search('program_title        = "([^"]+)"', r, re.DOTALL)
#             title = m.group(1) if m else data2
#             m = re.search('<a class="episode">Pārraides laiks ēterā: <span>([^<]+)</span></a>', r, re.DOTALL)
#             datums = m.group(1) if m else ""
#             title = title + " " + datums
#             m = re.search('<div id="panel">([^<]+)<', r, re.DOTALL)
#             desc = m.group(1) if m else title
#             m = re.search('<div id="panel">([^<]+)<', r, re.DOTALL)
#             desc = m.group(1) if m else title
#             m = re.search('var share_image *= "([^"]+)', r, re.DOTALL)
#             img = m.group(1) if m else ""
#             return (title,data2,img,desc)

    def get_streams(self,data):
        print "[tvdom] get_streams:", data
        if not self.is_video(data):
            return []
        source,data,path,plist,clist,params,qs = self.parse_data(data)
        if not self.session:
            self.login()
        url = "https://tvdom.tv/" + data
        headers = self.headers
        headers["Cookie"] = "PHPSESSID=%s; neverending_story=1;"%self.session
        r = self._http_request(url,headers=headers)

        if clist == "play_arhivs":
            m = re.search('program_title        = "([^"]+)"', r, re.DOTALL)
            title = m.group(1) if m else data2
            m = re.search('<a class="episode">Pārraides laiks ēterā: <span>([^<]+)</span></a>', r, re.DOTALL)
            datums = m.group(1) if m else ""
            title = title + " " + datums
            m = re.search('<div id="panel">([^<]+)<', r, re.DOTALL)
            desc = m.group(1) if m else title
            m = re.search('<div id="panel">([^<]+)<', r, re.DOTALL)
            desc = m.group(1) if m else title
            m = re.search('var share_image *= "([^"]+)', r, re.DOTALL)
            img = m.group(1) if m else ""

            m = re.search(r"var streams\s*= ({[^;]+);", r, re.DOTALL)
            if not m:
                raise Exception("No stream found")
            js = json.loads(m.group(1))
            streams = []
            for st in js:
                if st == "qualities": continue
                s = js[st]
                data2 = s["url"]
                stream = util.item()
                stream["name"] = title
                stream["url"] = data2
                stream["img"] = img
                stream["desc"] = desc
                stream["resolver"] = "tvdom"
                stream["quality"] = st
                stream["order"] = int(st[:-1])
                streams.append(stream)

            streams = sorted(streams,key=lambda item: item["order"],reverse=True)
            return streams

        # Tiešraides video
        else:
            m = re.search("var streamConnectionUrl = '([^']+)'", r, re.DOTALL)
            if m:
                data2 = m.group(1)
            else:
                if "no_player_body" in r:
                    raise Exception("Lai skatītos maksas kanālus, nepieciešams iegādāties abonementu")
                raise Exception("No stream found")
            m = re.search('title: "([^"]+)"', r, re.DOTALL)
            title = m.group(1) if m else data2
            m = re.search('<div id="panel">([^<]+)<', r, re.DOTALL)
            desc = m.group(1) if m else title
            m = re.search('<div id="panel">([^<]+)<', r, re.DOTALL)
            desc = m.group(1) if m else title
            m = re.search('var promo_image *= "([^"]+)', r, re.DOTALL)
            img = m.group(1) if m else ""
            stream = util.item()
            stream["name"] = title
            stream["url"] = data2
            stream["img"] = img
            stream["desc"] = desc
            stream["resolver"] = "tvdom"
            return [stream]


    def is_video(self,data):
        source,data,path,plist,clist,params,qs = self.parse_data(data)
        cmd = data.split("/")
        if cmd[0] in ("tiesraides") and len(cmd)>1:
            return True
        elif cmd[0]=="play_arhivs" and len(cmd)==3 and re.search("_\d+",plist[2]):
            return True
        else:
            return False


if __name__ == "__main__":
    sys.path.insert(0, os.path.dirname(os.path.dirname(__file__)))
    import run
    source = Source()
    data= sys.argv[1] if len(sys.argv)>1 else source.name+"::home"
    run.run(source, data)
    sys.exit()
